classdef class_REVS_dual_clutch
	%class_REVS_torque_converter
	%   Definition of class_REVS_torque_converter class
	
	properties
		
input_inertia_kgm2 = 0.0;			% Rotational Inertia of Input Shaft kgm^2
output1_inertia_kgm2 = 0.0;			% Rotational Inertia of Output Shaft 1 kgm^2
output2_inertia_kgm2 = 0.0;			% Rotational Inertia of Output Shaft 2 kgm^2

engage_duration_secs = 0.2;	% Clutch engagement minimum duration - used as rate limiter when shifting [secs]

torque_capacity_Nm;				% Maximum torque transfer avaialble via clutch

input_torque_loss_Nm;			% Torque Loss applied at input {Dynamic Lookup]

	end
		
	properties ( Dependent = true, SetAccess = private, Transient = true)


    end

	
	methods
			
		
		function obj = class_REVS_dual_clutch(engine)
			
			if nargin >= 1
			
			obj.torque_capacity_Nm = 1.8 * engine.max_torque_Nm;
			
			end
			
		end
		

		%TODO Add getter for 0 defaul tin put torque loss
		
		
	end
	
end



